unit aspxDelphiWCL.ResourcesHandler;

{

Copyright:  aspxDelphi.net All rights reserved. Use freely.

Zarko Gajic
http://aspxdelphi.net
http://delphi.about.com

}

interface
  uses System.Web, System.io, System.Reflection, System.Drawing, System.Drawing.Imaging;

type
  ResourcesHelper = class sealed
  public
    const ResourceMarker = 'r';

    const Emoticon_Script = 'aspxd_emoticon.js';
  end;

  ResourcesHandler = class(System.Object, IHttpHandler)
  private
    procedure RenderImage(context :HttpContext; imageName : string);
    procedure RenderScript(context :HttpContext; scriptName : string);
    function GetResource(resource : string) : string;
  public
    const HandlerURL = '~/aspxDelphiWCL.axd';
    procedure ProcessRequest(context: HttpContext);
    function get_IsReusable: Boolean;
  end;

implementation



function ResourcesHandler.get_IsReusable: Boolean;
begin
  Result := true;
end;

procedure ResourcesHandler.ProcessRequest(context: HttpContext);
var
  cRequest : string;
begin
  cRequest := context.Request[ResourcesHelper.ResourceMarker];

  if cRequest.EndsWith('.gif') then
  begin
    RenderImage(context, cRequest);
  end;

  if cRequest.EndsWith('.js') then
  begin
    RenderScript(context, cRequest);
  end;
end;

procedure ResourcesHandler.RenderImage(context: HttpContext; imageName: string);
var
  s : Stream;
  img : System.Drawing.Image;
begin
  context.Response.ClearHeaders;
  context.Response.Clear;
  context.Response.ContentType := 'image/gif';
  context.Response.AddHeader('Content-Disposition', System.String.Format('attachment;filename={0}', imageName));

  s := Assembly.GetExecutingAssembly().GetManifestResourceStream(imageName);
  try
    img := System.Drawing.Image.FromStream(s);
    img.Save(context.Response.OutputStream,System.Drawing.Imaging.ImageFormat.Gif);
  finally
    s.Close;
  end;
  context.Response.&End;
end;

procedure ResourcesHandler.RenderScript(context: HttpContext; scriptName: string);
var
  script : string;
begin
  context.Response.ClearHeaders();
  context.Response.Clear();
  context.Response.ContentType := 'application/x-javascript';
  context.Response.AddHeader('Content-Disposition', System.String.Format('attachment;filename={0}', scriptName));
  script := GetResource(scriptName);
  context.Response.Write(script);
  context.Response.&End();
end;

function ResourcesHandler.GetResource(resource: string): string;
var
  sr : StreamReader;
begin
  sr := StreamReader.Create(Assembly.GetExecutingAssembly().GetManifestResourceStream(resource));
  try
    Result := sr.ReadToEnd;
  finally
    sr.Close;
  end;
end;

end.
